alter table `idx_bad_link` change `bad_link_id` `bad_link_id` mediumint(9) unsigned NOT NULL auto_increment;
alter table `idx_bad_link` change `link_id` `link_id` mediumint(9) unsigned NOT NULL default '0';

alter table `idx_category` change `category_id` `category_id` mediumint(9) unsigned NOT NULL auto_increment;
alter table `idx_category` change `parent_id` `parent_id` mediumint(9) unsigned NOT NULL default '0';
alter table `idx_category` change `related` `related` mediumint(9) NOT NULL default '0';
alter table `idx_category` add `premium_price` double default NULL;
alter table `idx_category` add `sponsored_price` double default NULL;

alter table `idx_checkurl` change `date` `date` date NOT NULL default '0000-00-00';
alter table `idx_checkurl` add `live` char(1) NOT NULL default '';
alter table `idx_checkurl` add `reciprocal_found` char(1) NOT NULL default '';
alter table `idx_checkurl` add PRIMARY KEY  (`link_id`);

CREATE TABLE `idx_invoice` (
  `invoice_id` varchar(10) NOT NULL default '',
  `invoice_date` date default NULL,
  `due_date` date default NULL,
  `invoiced_to` text,
  `service` varchar(255) default NULL,
  `description` text,
  `total` double(8,2) default NULL,
  `comment` text,
  `paid` char(1) default NULL,
  `paid_date` date default NULL,
  `email` varchar(255) default NULL,
  PRIMARY KEY  (`invoice_id`)
);

CREATE TABLE `idx_invoice_config` (
  `company` varchar(255) default NULL,
  `contact` varchar(255) default NULL,
  `address` text,
  `phone` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `currency` varchar(255) default NULL
);

alter table `idx_link` change `link_id` `link_id` mediumint(9) unsigned NOT NULL auto_increment;
alter table `idx_link` change `category_id` `category_id` mediumint(9) unsigned NOT NULL default '0';
alter table `idx_link` change `cat1` `cat1` mediumint(9) NOT NULL default '0';
alter table `idx_link` change `cat2` `cat2` mediumint(9) NOT NULL default '0';
alter table `idx_link` add `reciprocal_url` varchar(255) default NULL AFTER `suspended`;

alter table `idx_link_temp` change `vid` `vid` mediumint(9) unsigned NOT NULL auto_increment;
alter table `idx_link_temp` change `link_id` `link_id` mediumint(9) default NULL;
alter table `idx_link_temp` change `cat1` `cat1` mediumint(9) NOT NULL default '0';
alter table `idx_link_temp` change `cat2` `cat2` mediumint(9) NOT NULL default '0';
alter table `idx_link_temp` add `reciprocal_url` varchar(255) default NULL AFTER `suspended`;

CREATE TABLE `idx_link_temp_user` (
  `vid` mediumint(9) unsigned NOT NULL default '0',
  `username` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`vid`)
);

CREATE TABLE `idx_link_user` (
  `link_id` mediumint(9) unsigned NOT NULL default '0',
  `username` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`link_id`)
);

CREATE TABLE `idx_notification` (
  `username` varchar(20) NOT NULL default '',
  `category_id` mediumint(9) NOT NULL default '0'
);

CREATE TABLE `idx_paid_listing` (
  `link_id` mediumint(9) unsigned NOT NULL default '0',
  `premium` char(1) default NULL,
  `sponsored` char(1) default NULL,
  `expire` datetime default NULL,
  `paid` char(1) default NULL,
  PRIMARY KEY  (`link_id`)
);

CREATE TABLE `idx_payment_history` (
  `payment_id` int(10) unsigned NOT NULL auto_increment,
  `username` varchar(255) default NULL,
  `type` varchar(255) default NULL,
  `detail` text,
  `amount` double default NULL,
  `time` datetime default NULL,
  PRIMARY KEY  (`payment_id`)
);

alter table `idx_review` change `review_id` `review_id` mediumint(9) unsigned NOT NULL auto_increment;
alter table `idx_review` change `link_id` `link_id` mediumint(9) unsigned NOT NULL default '0';
alter table `idx_review` add `name` varchar(20) default NULL;
alter table `idx_review` add `email` varchar(100) default NULL;

alter table `idx_searchlog` change `result` `result` mediumint(9) unsigned default NULL;

alter table `idx_sessions` add `EXPIREREF` varchar(64) default NULL;

CREATE TABLE `idx_pagerank` (
  `link_id` mediumint(8) unsigned NOT NULL default '0',
  `engine` char(1) NOT NULL default '',
  `rank` tinyint(4) NOT NULL default '0',
  `last_update` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`link_id`,`engine`)
);

CREATE TABLE `idx_custom_field` (
  `field_name` varchar(32) NOT NULL default '',
  `field_text` varchar(64) NOT NULL default '',
  `field_type` enum('TEXT','TEXTAREA','SELECT','MULTISELECT','CHECKBOX','RADIO','FILE','IMAGE','DATE','DATETIME') NOT NULL default 'TEXT',
  `field_option` text NOT NULL,
  `field_img_width` INT(10) unsigned NOT NULL default '0',
  `field_img_height` INT(10) unsigned NOT NULL default '0',
  `field_file_size` INT(10) unsigned NOT NULL default '0',
  `field_file_extension` varchar(64) NOT NULL default '',
  `required` char(1) NOT NULL default '0',
  `searchable` char(1) NOT NULL default '1',
  `permission` char(1) NOT NULL default '0'
);

insert into `idx_invoice_config`
    (company, contact, address, phone, email, currency) values
    ('Your website / Company', 'Billing Department', 'Your address', 'Your phone #', 'Billing<name@yourdomain.com>', '$');

alter table `idx_category` add `basic_price` double unsigned NOT NULL default '0' after `order_num`;
alter table `idx_category` change `premium_price` `premium_price` double unsigned NOT NULL default '0';
alter table `idx_category` change `sponsored_price` `sponsored_price` double unsigned NOT NULL default '0';

alter table `idx_invoice_config` change `currency` `currency_symbol` varchar(255) default '$';
alter table `idx_invoice_config` add `currency_code` varchar(255) default 'USD';

alter table `idx_link` change `suspended` `suspended` char(1) NOT NULL default '0';
alter table `idx_link` change `bid` `bid` smallint(6) NOT NULL default '0';
alter table `idx_link` drop `sp_cat`;
alter table `idx_link` drop `sp_cat_date_limit`;
alter table `idx_link` drop `sp_cat_order`;
alter table `idx_link_temp` change `suspended` `suspended` char(1) NOT NULL default '0';
alter table `idx_link_temp` change `bid` `bid` smallint(6) NOT NULL default '0';
alter table `idx_link_temp` drop `sp_cat`;
alter table `idx_link_temp` drop `sp_cat_date_limit`;
alter table `idx_link_temp` drop `sp_cat_order`;

alter table `idx_users` drop `theme`;
alter table `idx_users` drop `nol_category`;
alter table `idx_users` drop `nol_search`;

drop table `idx_category_in_order`;